#include <iostream>
#include <vector>

using namespace std;

int niz[200005];
int n;

vector<vector<int>> slova;

vector<vector<int>> make_slova()
{
    vector<vector<int>> s;
    vector<int> v(26);
    fill(v.begin(), v.end(), 0);
    s.push_back(v);

    for(int i=0; i<n; i++)
    {
        vector<int> v1(s.back().begin(), s.back().end());
        v1[niz[i]]++;
        s.push_back(v1);
    }
    return s;
}

bool subset(int l, int r)
{
    for(int i=0; i<26; i++)
    {
        if(slova[l][i]>slova.back()[i]-slova[r][i])
            return false;
    }
    return true;
}

int best()
{
    int middle = n/2;
    for(int i=0; i<middle;i++)
    {
        if(!subset(i+1, i+1))
            return n-i;
    }
    int m1=middle-1;
    int m2=(n+1)/2;
    if(!subset(middle, m2))
        return n-middle;
    for(int i=0; i<n; i++)
    {
        if(niz[m1-i]!=niz[m2+i])
            return n-m2-i;
    }
    return 0;
}

void ispis()
{
    cout<<n<<endl;
    for(int i=0; i<n; i++)
        cout<<niz[i]<<" ";
    cout<<endl;
    for(int i=0; i<n+1; i++)
    {
        for(int j=0; j<26; j++)
        {
            cout<<slova[i][j]<<" ";
        }
        cout<<endl;
    }
    cout<<endl;
}

int main()
{
    string s;
    cin>>s;
    int k = -1;
    n = s.length();
    for(int i=0; i<n; i++)
    {
        if(s[i]!=s[n-i-1])
        {
            k=i;
            break;
        }
    }
    if(k==-1){
        cout<<1;
        return 0;
    }

    n=n-2*k;

    for(int i=0; i<n; i++)
    {
        niz[i]=s[i+k]-'a';
    }

    slova= make_slova();
    //ispis();
    int r1 = best();

    int a1= 0, a2=n-1;
    while(a1<a2)
    {
        swap(niz[a1],niz[a2]);
        a1++;
        a2--;
    }
    slova = make_slova();
    //ispis();
    int r2 = best();

    cout<<min(r1,r2);

    return 0;
}